/*=================================================================*/
/*=== Squelette de projet ISN avec la balise Canvas             ===*/
/*=== Auteur : Valéry Bruniaux - L’ensemble du contenu de ce    ===*/
/*=== site web, est mis à disposition sous licence CC-BY-NC-SA  ===*/
/*=== https://creativecommons.org/licenses/by-nc-sa/4.0/deed.fr ===*/
/*=================================================================*/

/*====================*/
/*=== Global space ===*/
/*====================*/

// Tilt angle for Gyroscope analysis
var tiltLR = 0;
var titleFB = 0;
var angleLimite = 10;

// For mouse sensibility
var mouseSensibility = 5;

// Mob position
var largeurcarre = 10;
var posX =100;
var posY = 100;

// Mob moving
var speed = 7;
// manage directions D ou G puis H et B
var direction = ["", ""]

// Graphic objects
var canvas;
var context;
var backgroundContext;
var parcours = new Image();
	parcours.src = "parcours.png";	// preload image

/*==================*/
/*=== Code start ===*/
/*==================*/
window.onload = function()		// At start
{
var backgroundCanvas;

	//init background for collision test
	backgroundCanvas = document.createElement( "canvas" );
	// Adjust backgroundCanvas size at window's size
	backgroundCanvas.width = window.innerWidth;
	backgroundCanvas.height = window.innerHeight;
	// Init backgroundContext for collision test
	backgroundContext = backgroundCanvas.getContext("2d");
	// Draw background in backgroundContext
	backgroundContext.drawImage(parcours,0,0,window.innerWidth,window.innerHeight);
	
	//init our canvas and graphic context
	canvas = document.getElementById("myCanvas");
	// Adjust backgroundCanvas size at window's size
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
	// Init context to draw the game
	context = canvas.getContext("2d");	

	// Tilt angle control
	// Check to make sure the browser supports DeviceOrientationEvents
	if (window.DeviceOrientationEvent)
	{
		// Create an event listener
		window.addEventListener('deviceorientation', function(event)
		{
			// Get the left-to-right tilt (in degrees).
			tiltLR = event.gamma;
			// Get the front-to-back tilt (in degrees).
			titleFB = event.beta;
			// Get the direction of the device (in degrees).
			//direction = event.alpha;
		
			if ( tiltLR > angleLimite )
			{
				direction[0] = "D"
			}
			else if ( tiltLR < -angleLimite )
			{
				direction[0] = "G"
			}
			else direction[0] = "";
	
			if ( titleFB > angleLimite )
			{
				direction[1] = "B"
			}
			else if ( titleFB < -angleLimite )
			{
				direction[1] = "H"
			}
			else direction[1] = ""
			
		}, false);
	}

	// Stop at start
	direction = ["",""];

	// Render the scene
	dessine();

	// launch animation
	setInterval(animate,20);
}

// Mouse control
window.onmousemove=function(event)
{
	direction = ["",""];
	if ( event.clientX - posX > mouseSensibility ) direction[0] = "D"
	else if ( event.clientX - posX < -mouseSensibility ) direction[0] = "G"

	if ( event.clientY - posY > mouseSensibility ) direction[1] = "B"
	else if ( event.clientY - posY < -mouseSensibility ) direction[1] = "H"
}

// Keyboard control
window.onkeydown=function(event)		// At key pressed
{
    switch ( event.keyCode )
    {
        case 39 :   direction[0] = "D";
                    break;
        case 37 :   direction[0] = "G";
                    break;
        case 38 :   direction[1] = "H";
                    break;
        case 40 :   direction[1] = "B";
                    break;    
    }
}

window.onkeyup=function(event)		// At key pressed
{
    if ( event.keyCode == 39 || event.keyCode == 37 ) direction[0] = ""
    else if ( event.keyCode == 38 || event.keyCode == 40 ) direction[1] = ""
}

// Animation
function avance_position()		// Mob moving
{
	switch (direction[0])
	{
		case "G" : 
			posX -= speed;
		break;
		
		case "D" : 
			posX += speed;
		break;
	}
	switch (direction[1])
	{
		case "H" :
			posY -= speed;
		break;
		
		case "B" : 
			posY += speed;
		break;
	}
}

function animate()	// Animation core
{
	avance_position();

	if ( isCollision() )
	{
		// Collision do something !
		
	}
	else
	{		
		dessine();
	}
}

function dessine()	// Draw the scene
{
	// Clear
	context.clearRect(0, 0, canvas.width, canvas.height);
	
	// Draw Background
	context.drawImage(parcours,0,0, canvas.width, canvas.height );
	
	// Draw Mob
	context.beginPath();
	context.rect(posX, posY, largeurcarre,largeurcarre);
	context.closePath();
	context.fill();	
}

function isCollision()	// Check for color detection
{
	var photo = backgroundContext.getImageData(posX, posY,largeurcarre,largeurcarre);

	for (var i = 0 ; i < photo.data.length ; i += 4)
	{
	// test rouge
		if (photo.data[i] == 237 && photo.data[i+1] == 28 && photo.data[i+2] == 36)
		{
			alert("Rouge !");
			return true;
		}
		// test bleu
		if (photo.data[i] == 63 && photo.data[i+1] == 72 && photo.data[i+2] == 204 )
		{
			alert("Bleu !");
			return true;
		}
		// test noir
		if (photo.data[i] == 0 && photo.data[i+1] == 0 && photo.data[i+2] == 0 )
		{
			alert("Noir !");
			return true;
		}
	}
	return false;
}
